<?php
/**
 * Environment
 *
 * Copyright (c) 2014, Sebastian Bergmann <sebastian@phpunit.de>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *
 *   * Neither the name of Sebastian Bergmann nor the names of his
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @package    Environment
 * @author     Sebastian Bergmann <sebastian@phpunit.de>
 * @copyright  2014 Sebastian Bergmann <sebastian@phpunit.de>
 * @license    http://www.opensource.org/licenses/BSD-3-Clause  The BSD 3-Clause License
 * @link       http://www.github.com/sebastianbergmann/environment
 */

namespace SebastianBergmann\Environment;

/**
 * @package    Environment
 * @author     Sebastian Bergmann <sebastian@phpunit.de>
 * @copyright  2014 Sebastian Bergmann <sebastian@phpunit.de>
 * @license    http://www.opensource.org/licenses/BSD-3-Clause  The BSD 3-Clause License
 * @link       http://www.github.com/sebastianbergmann/environment
 */
class Console {
	/**
	 * Returns true if STDOUT supports colorization.
	 *
	 * This code has been copied and adapted from
	 * Symfony\Component\Console\Output\OutputStream.
	 *
	 * @return boolean
	 */
	public function hasColorSupport () {
		if ( DIRECTORY_SEPARATOR == '\\' ) {
			return false !== getenv( 'ANSICON' ) || 'ON' === getenv( 'ConEmuANSI' );
		}

		if ( ! defined( 'STDOUT' ) ) {
			return false;
		}

		return $this->isTty( STDOUT );
	}

	/**
	 * Returns the number of columns of the terminal.
	 *
	 * @return integer
	 */
	public function getNumberOfColumns () {
		// Windows terminals have a fixed size of 80
		// but one column is used for the cursor.
		if ( DIRECTORY_SEPARATOR == '\\' ) {
			return 79;
		}

		if ( ! defined( 'STDIN' ) || ! $this->isTty( STDIN ) ) {
			return 80;
		}

		if ( preg_match( '#\d+ (\d+)#', shell_exec( 'stty size' ), $match ) === 1 ) {
			return (int) $match[1];
		}

		if ( preg_match( '#columns = (\d+);#', shell_exec( 'stty' ), $match ) === 1 ) {
			return (int) $match[1];
		}

		return 80;
	}

	/**
	 * @param  resource $fd
	 *
	 * @return boolean
	 */
	private function isTty ( $fd ) {
		return function_exists( 'posix_isatty' ) && @posix_isatty( $fd );
	}
}
